﻿using System;

using System.Web;

namespace VIRP_WEB.Custom.EFR
{
    public partial class PatientRelatedDiagnoses : EfrBasePage
    {
        private int patientId;

        protected override void Page_Load(object sender, EventArgs e)
        {
            ReplacePageTitle();

            if (!IsPostBack)
            {
                var patientSummary = GetOrStorePatientSummary();
                if (patientSummary != null)
                {
                    LabelPatientName.Text = patientSummary.FullName;
                    LabelPatientSnum.Text = patientSummary.Snum;

                    ReplacePageTitle("Patients > Patient Lookup > Related Diagnoses  > " + patientSummary.FullName);
                }

                SetupCommonDataSourceParameters();
            }

            // Added for 508 compliance with GridView column headers and footer
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridViewRelatedDiagnostics.ClientID + "');", true);
        }

        private void SetupCommonDataSourceParameters()
        {
            var currentUser = HttpContext.Current.User.Identity.Name;
            ObjectDataSourceRelatedDiagnostics.SelectParameters["CURRENT_USER"].DefaultValue = currentUser;

            var currentRegistry = UserSession.CurrentRegistryId.ToString();
            ObjectDataSourceRelatedDiagnostics.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = currentRegistry;
        }

        protected void LinkButtonPatientInformation_Click(object sender, EventArgs e)
        {
            if (int.TryParse(Request.QueryString["patientId"], out patientId))
                Response.Redirect(string.Format("~/Custom/EFR/Patients/Patient.aspx?PatientId={0}", patientId), false);
        }

        protected void LinkButtonWorkflows_Click(object sender, EventArgs e)
        {
            if (int.TryParse(Request.QueryString["patientId"], out patientId))
                Response.Redirect(string.Format("~/Custom/EFR/Patients/PatientWorkflows.aspx?PatientId={0}", patientId), false);
        }

        protected void LinkButtonLabTests_Click(object sender, EventArgs e)
        {
            if (int.TryParse(Request.QueryString["patientId"], out patientId))
                Response.Redirect(string.Format("~/Custom/EFR/Patients/PatientRelatedLabTests.aspx?PatientId={0}", patientId), false);
        }

        protected void LinkButtonImages_Click(object sender, EventArgs e)
        {
            if (int.TryParse(Request.QueryString["patientId"], out patientId))
                Response.Redirect(string.Format("~/Custom/EFR/Patients/PatientImaging.aspx?PatientId={0}", patientId), false);
        }
    }
}